<?php
/*
Plugin Name: Farzin Auto Linker
Description: لینک‌دهی خودکار بر اساس انکر و لینک تعیین شده توسط فرزین اعتماد.
Version: 3.5
Author: فرزین اعتماد 
*/

// جلوگیری از دسترسی مستقیم به فایل
if (!defined('ABSPATH')) {
    exit;
}

// افزودن منوی تنظیمات به پیشخوان
add_action('admin_menu', 'farzin_auto_linker_menu');
function farzin_auto_linker_menu() {
    add_menu_page(
        'Farzin Auto Linker',
        'Auto Linker',
        'manage_options',
        'farzin-auto-linker',
        'farzin_auto_linker_settings_page',
        'dashicons-admin-links',
        100
    );

    add_submenu_page(
        'farzin-auto-linker',
        'گزارشات لینک‌ها',
        'گزارشات',
        'manage_options',
        'farzin-auto-linker-reports',
        'farzin_auto_linker_reports_page'
    );
}

// صفحه تنظیمات پلاگین
function farzin_auto_linker_settings_page() {
    if (!current_user_can('manage_options')) {
        return;
    }

    // ذخیره داده‌ها
    if (isset($_POST['farzin_links'])) {
        $links = array_values(array_filter($_POST['farzin_links'], function($value) {
            return !empty($value['anchor']) && !empty($value['url']);
        }));
        foreach ($links as $index => &$link) {
            $link['once_per_page'] = isset($link['once_per_page']) ? 1 : 0;
        }
        update_option('farzin_auto_links', $links);

        echo '<div class="updated"><p>تنظیمات ذخیره شد.</p></div>';
    }

    // حذف انکرها از گزارش
    if (isset($_POST['delete_anchor']) && !empty($_POST['delete_anchor'])) {
        $links = get_option('farzin_auto_links', []);
        $anchor_to_delete = sanitize_text_field($_POST['delete_anchor']);
        $links = array_values(array_filter($links, function($link) use ($anchor_to_delete) {
            return $link['anchor'] !== $anchor_to_delete;
        }));
        update_option('farzin_auto_links', $links);

        $reports = get_option('farzin_auto_linker_reports', []);
        $reports = array_filter($reports, function($report) use ($anchor_to_delete) {
            return $report['anchor'] !== $anchor_to_delete;
        });
        update_option('farzin_auto_linker_reports', $reports);

        echo '<div class="updated"><p>انکر و گزارش‌های مربوطه حذف شدند.</p></div>';
    }

    // دریافت لینک‌های ذخیره‌شده
    $links = get_option('farzin_auto_links', []);

    ?>
    <div class="wrap">
        <h1>Farzin Auto Linker</h1>
        <form method="post">
            <h2>افزودن لینک‌ها</h2>
            <table class="form-table" id="farzin-links-table">
                <thead>
                <tr>
                    <th>انکر</th>
                    <th>لینک</th>
                    <th>فقط یک بار در هر صفحه</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>
                <?php if (!empty($links)) : ?>
                    <?php foreach ($links as $index => $link) : ?>
                        <tr>
                            <td><input type="text" name="farzin_links[<?php echo $index; ?>][anchor]" value="<?php echo esc_attr($link['anchor']); ?>" /></td>
                            <td><input type="text" name="farzin_links[<?php echo $index; ?>][url]" value="<?php echo esc_url($link['url']); ?>" /></td>
                            <td><input type="checkbox" name="farzin_links[<?php echo $index; ?>][once_per_page]" value="1" <?php checked(isset($link['once_per_page']) ? $link['once_per_page'] : 0, 1); ?> /></td>
                            <td><button type="submit" name="delete_anchor" value="<?php echo esc_attr($link['anchor']); ?>" class="button">حذف</button></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                </tbody>
            </table>
            <button type="button" class="button" id="add-row">افزودن لینک</button>

            <p class="submit">
                <input type="submit" class="button-primary" value="ذخیره تغییرات" />
            </p>
        </form>
    </div>

    <script>
        document.getElementById('add-row').addEventListener('click', function () {
            const tableBody = document.querySelector('#farzin-links-table tbody');
            const rowCount = tableBody.children.length;
            const row = document.createElement('tr');
            row.innerHTML = '<td><input type="text" name="farzin_links[' + rowCount + '][anchor]" /></td>' +
                '<td><input type="text" name="farzin_links[' + rowCount + '][url]" /></td>' +
                '<td><input type="checkbox" name="farzin_links[' + rowCount + '][once_per_page]" value="1" /></td>' +
                '<td><button type="button" class="button remove-row">حذف</button></td>';
            tableBody.appendChild(row);
        });

        document.addEventListener('click', function (e) {
            if (e.target && e.target.classList.contains('remove-row')) {
                e.target.closest('tr').remove();
            }
        });
    </script>
    <?php
}

// گزارش لینک‌ها
function farzin_auto_linker_reports_page() {
    if (!current_user_can('manage_options')) {
        return;
    }

    $reports = get_option('farzin_auto_linker_reports', []);
    $grouped_reports = [];

    foreach ($reports as $report) {
        $grouped_reports[$report['anchor']][] = $report;
    }

    ?>
    <div class="wrap">
        <h1>گزارش لینک‌های ایجاد شده</h1>
        <?php if (!empty($grouped_reports)) : ?>
            <?php foreach ($grouped_reports as $anchor => $entries) : ?>
                <h2>انکر: <?php echo esc_html($anchor); ?></h2>
                <table class="widefat">
                    <thead>
                    <tr>
                        <th>لینک</th>
                        <th>صفحه</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($entries as $entry) : ?>
                        <tr>
                            <td><a href="<?php echo esc_url($entry['url']); ?>" target="_blank"><?php echo esc_url($entry['url']); ?></a></td>
                            <td><a href="<?php echo esc_url($entry['page']); ?>" target="_blank"><?php echo esc_url($entry['page']); ?></a></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endforeach; ?>
        <?php else : ?>
            <p>هیچ گزارشی یافت نشد.</p>
        <?php endif; ?>
    </div>
    <?php
}

// جایگزینی انکرها با لینک‌ها فقط در پست‌ها
add_filter('the_content', 'farzin_auto_linker_replace_links', 10);
function farzin_auto_linker_replace_links($content) {
    if (!is_singular('post')) {
        return $content;
    }

    $links = get_option('farzin_auto_links', []);
    $reports = get_option('farzin_auto_linker_reports', []);
    $processed_anchors = [];

    if (!empty($links)) {
        foreach ($links as $link) {
            if (get_permalink() === $link['url']) {
                continue;
            }

            $content = preg_replace_callback('/\b' . preg_quote($link['anchor'], '/') . '\b/u', function($matches) use ($link, &$reports, &$processed_anchors) {
                global $post;
                if (!empty($link['once_per_page']) && in_array($matches[0], $processed_anchors)) {
                    return $matches[0];
                }

                $processed_anchors[] = $matches[0];
                $reports[] = [
                    'anchor' => $matches[0],
                    'url' => $link['url'],
                    'page' => get_permalink($post)
                ];
                return '<a href="' . esc_url($link['url']) . '" target="_blank">' . esc_html($matches[0]) . '</a>';
            }, $content);
        }
        update_option('farzin_auto_linker_reports', $reports);
    }

    return $content;
}

// حذف گزارشات هنگام غیرفعال‌سازی افزونه
register_deactivation_hook(__FILE__, 'farzin_auto_linker_deactivate');
function farzin_auto_linker_deactivate() {
    delete_option('farzin_auto_linker_reports');
}

// اعمال لینک‌دهی هنگام انتشار پست جدید
add_action('save_post', 'farzin_auto_linker_update_post_content', 10, 3);
function farzin_auto_linker_update_post_content($post_id, $post, $update) {
    if (wp_is_post_autosave($post_id) || wp_is_post_revision($post_id) || $post->post_type !== 'post' || $post->post_status !== 'publish') {
        return;
    }

    remove_action('save_post', 'farzin_auto_linker_update_post_content', 10);

    $content = apply_filters('the_content', $post->post_content);
    wp_update_post([
        'ID' => $post_id,
        'post_content' => $content
    ]);

    add_action('save_post', 'farzin_auto_linker_update_post_content', 10, 3);
}
